BEGIN TRANSACTION

IF EXISTS(SELECT NULL FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'Pardakht')
	BEGIN
		PRINT 'Already Updated!'
		ROLLBACK TRANSACTION
	END
GO

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'Setting' AND column_name = 'DBVersion')
	ALTER TABLE [dbo].[Setting] ADD [DBVersion] [varchar] (50) COLLATE Arabic_CI_AS NULL
GO

IF NOT EXISTS( SELECT NULL
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE table_name = 'factor1'
             AND column_name = 'id') 
ALTER TABLE factor1 ADD [ID] [int] IDENTITY (1, 1) NOT NULL 
Go

IF @@TRANCOUNT = 1 UPDATE Factor1 SET [Time]=REPLACE([Time],' ',':')
WHERE CHARINDEX(' ',[Time])>0
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
CREATE TABLE [Daryaft] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[CodeDaryaft] [varchar] (10) COLLATE Arabic_CI_AS NULL ,
	[Date] [char] (10) COLLATE Arabic_CI_AS NULL ,
	[Price] [money] NULL ,
	[Info] [varchar] (500) COLLATE Arabic_CI_AS NULL ,
	[Time] [char] (8) COLLATE Arabic_CI_AS NULL ,
	[Code] [int] NULL ,
	[TypeCodeDaryaft] [tinyint] NULL ,
	[Takhfif] [money] NULL ,
	[FactorId] [int] NULL CONSTRAINT [DF_Daryaft_FactorId] DEFAULT (0),
	[SanadNo] [int] NULL ,
	CONSTRAINT [PK_Daryaft] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
CREATE TABLE [Daryaft2] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[DaryaftID] [int] NULL ,
	[Price] [money] NULL ,
	[SandooghHesab] [char] (8) COLLATE Arabic_CI_AS NULL ,
	[BankID] [int] NULL ,
	[SodorID] [int] NULL ,
	[VosoulID] [int] NULL ,
	[ShakhsID] [int] NULL ,
	[FishNo] [nvarchar] (50) COLLATE Arabic_CI_AS NULL ,
	[Info] [nvarchar] (500) COLLATE Arabic_CI_AS NULL ,
	CONSTRAINT [PK_Daryaft2] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
BEGIN
	alter table VosoulInfo add [Daryaft2ID] [int]
	alter table VosoulInfo add [Pardakht2ID] [int]
	alter table SodorInfo add [Pardakht2ID] [int]
END
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO


IF @@TRANCOUNT = 1 DELETE FROM tblDaryaft WHERE IDShakhs NOT IN (SELECT IDShakhs FROM AShkhasList)
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

--Hazfe Asnade Factorhayi ke daryaft va pardakht darand-----------------
IF @@TRANCOUNT = 1
BEGIN
	DELETE Sanad_Hesab2 WHERE SanadID IN (SELECT SanadNo FROM tblDaryaft WHERE NOT FactorID IS NULL)
	DELETE Sanad_Hesab2 WHERE SanadID IN (SELECT SanadNo FROM tblPardakht WHERE NOT FactorID IS NULL)
	DELETE Sanad_Hesab2 WHERE SanadID IN (SELECT Shomare_Sanad FROM VosoulInfo WHERE NOT FactorNo IS NULL)
	DELETE Sanad_Hesab2 WHERE SanadID IN (SELECT Shomare_Sanad FROM SodorInfo WHERE NOT FactorNo IS NULL)
	DELETE Sanad_Hesab2 WHERE SanadID IN 
		(select factor1.SanadNo
		from factor1 inner join tbldaryaft on factor1.factorno=tbldaryaft.factorid and
		factor1.date=tbldaryaft.factordate and factor1.type=tbldaryaft.factortype
		where NOT Factor1.SanadNo IS NULL
		UNION ALL
		select factor1.SanadNo
		from factor1 inner join tblPardakht on factor1.factorno=tblPardakht.factorid and
		factor1.date=tblPardakht.factordate and factor1.type=tblPardakht.factortype
		where NOT Factor1.SanadNo IS NULL)
	DELETE Sanad_Hesab1 WHERE [ID] IN (SELECT SanadNo FROM tblDaryaft WHERE NOT FactorID IS NULL)
	DELETE Sanad_Hesab1 WHERE [ID] IN (SELECT SanadNo FROM tblPardakht WHERE NOT FactorID IS NULL)	
	DELETE Sanad_Hesab1 WHERE [ID] IN (SELECT Shomare_Sanad FROM VosoulInfo WHERE NOT FactorNo IS NULL)
	DELETE Sanad_Hesab1 WHERE [ID] IN (SELECT Shomare_Sanad FROM SodorInfo WHERE NOT FactorNo IS NULL)
	DELETE Sanad_Hesab1 WHERE [ID] IN 
		(select factor1.SanadNo
		from factor1 inner join tbldaryaft on factor1.factorno=tbldaryaft.factorid and
		factor1.date=tbldaryaft.factordate and factor1.type=tbldaryaft.factortype
		where NOT Factor1.SanadNo IS NULL
		UNION ALL
		select factor1.SanadNo
		from factor1 inner join tblPardakht on factor1.factorno=tblPardakht.factorid and
		factor1.date=tblPardakht.factordate and factor1.type=tblPardakht.factortype
		where NOT Factor1.SanadNo IS NULL)
	UPDATE VosoulInfo SET Shomare_Sanad=NULL WHERE NOT FactorNo IS NULL
	UPDATE SodorInfo SET Shomare_Sanad=NULL WHERE NOT FactorNo IS NULL
	UPDATE Factor1 SET SanadNo=NULL	WHERE [ID] IN
		(select factor1.[ID]
		from factor1 inner join tbldaryaft on factor1.factorno=tbldaryaft.factorid and
		factor1.date=tbldaryaft.factordate and factor1.type=tbldaryaft.factortype
		where NOT Factor1.SanadNo IS NULL
		UNION ALL
		select factor1.[ID]
		from factor1 inner join tblPardakht on factor1.factorno=tblPardakht.factorid and
		factor1.date=tblPardakht.factordate and factor1.type=tblPardakht.factortype
		where NOT Factor1.SanadNo IS NULL)
END
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

-----------afzodane daryaft hayi ke dar factor sabt shode ast
IF @@TRANCOUNT = 1
INSERT INTO Daryaft(CodeDaryaft, [Date], Price, [Time], TypeCodeDaryaft, Takhfif, FactorId)
SELECT Factor1.IDShakhs,Factor1.[Date], tbl2.Price,
CONVERT(varchar,DATEADD(ss,2,CONVERT(datetime,Factor1.[Time])),108) AS [Time],
0 AS Type,0 AS Takhfif, Factor1.[ID]
FROM Factor1 INNER JOIN
(SELECT [Date],[No],[Type],SUM(Price) AS Price FROM (
SELECT FactorDate AS [Date],FactorID AS [No],FactorType AS [Type], Price
FROM tblDaryaft
WHERE NOT FactorID IS NULL
UNION ALL
SELECT DateFactor AS [Date],FactorNo AS [No],FactorType AS [Type], Price
FROM VosoulInfo
WHERE NOT FactorNo IS NULL) tbl
GROUP BY [Date],[No],[Type]) tbl2
ON Factor1.Type=tbl2.Type AND Factor1.[Date]=tbl2.[Date] AND Factor1.FactorNo=tbl2.[no]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
INSERT INTO Daryaft2([DaryaftID], [Price], [SandooghHesab], [BankID], [Info])
SELECT Daryaft.[ID],tblDaryaft.Price,Sandoogh_Code, CardReader.HesabID,tblDaryaft.Info
FROM tblDaryaft INNER JOIN Factor1 on factor1.factorno=tbldaryaft.factorid and
		factor1.date=tbldaryaft.factordate and factor1.type=tbldaryaft.factortype
INNER JOIN Daryaft ON Daryaft.FactorID=Factor1.[ID]
LEFT OUTER JOIN CardReader ON CardReader.[ID]=tblDaryaft.CardReaderID
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
DELETE FROM tblDaryaft WHERE NOT FactorID IS NULL
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
INSERT INTO Daryaft2([DaryaftID], [Price], [VosoulID])
SELECT Daryaft.[ID],VosoulInfo.Price,VosoulInfo.[ID]
FROM VosoulInfo INNER JOIN Factor1 on factor1.factorno=VosoulInfo.factorno and
		factor1.date=VosoulInfo.dateFactor and factor1.type=VosoulInfo.factortype
INNER JOIN Daryaft ON Daryaft.FactorID=Factor1.[ID]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
UPDATE VosoulInfo SET Daryaft2ID=(SELECT [ID] FROM Daryaft2 WHERE VosoulID=VosoulInfo.[ID])
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
BEGIN
	print 'Update Daryaft'
	insert into daryaft(codedaryaft,date,time,typecodedaryaft,SanadNo,price,info)
	select tbldaryaft.idshakhs,tbldaryaft.date,tbldaryaft.time,0,tbldaryaft.sanadno,tbldaryaft.price,tbldaryaft.info from tbldaryaft
END
Go
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 UPDATE Daryaft SET Code=[ID]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
BEGIN
	print 'Update Daryaft2'
	insert into daryaft2 (daryaftid,price,info,sandooghhesab,bankid)
	select daryaft.id,tbldaryaft.price,tbldaryaft.info,tbldaryaft.sandoogh_code,cardreader.hesabid  from tbldaryaft 
	INNER JOIN Daryaft ON tblDaryaft.[Date]=Daryaft.[Date] AND tblDaryaft.[Time]=Daryaft.[Time] AND tblDaryaft.[Price]=Daryaft.[Price]
	 left outer join cardreader  on tbldaryaft.cardreaderid=cardreader.id
END
Go
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO
---------------------------------------------------------------------------

IF @@TRANCOUNT = 1
CREATE TABLE [Pardakht] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[CodePardakht] [varchar] (10) COLLATE Arabic_CI_AS NULL ,
	[Date] [char] (10) COLLATE Arabic_CI_AS NULL ,
	[Price] [money] NULL ,
	[Info] [varchar] (500) COLLATE Arabic_CI_AS NULL ,
	[Time] [char] (8) COLLATE Arabic_CI_AS NULL ,
	[Code] [int] NULL ,
	[TypeCodePardakht] [tinyint] NULL ,
	[Takhfif] [money] NULL ,
	[FactorId] [int] NULL CONSTRAINT [DF_Pardakht_FactorId] DEFAULT (0),
	[SanadNo] [int] NULL ,
	CONSTRAINT [PK_Pardakht] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
CREATE TABLE [Pardakht2] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[PardakhtID] [int] NULL ,
	[Price] [money] NULL ,
	[SandooghHesab] [char] (8) COLLATE Arabic_CI_AS NULL ,
	[BankID] [int] NULL ,
	[SodorID] [int] NULL ,
	[VosoulID] [int] NULL ,
	[ShakhsID] [int] NULL ,
	[FishNo] [nvarchar] (50) COLLATE Arabic_CI_AS NULL ,
	[Info] [nvarchar] (500) COLLATE Arabic_CI_AS NULL ,
	CONSTRAINT [PK_Pardakht2] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO


IF @@TRANCOUNT = 1 DELETE FROM tblPardakht WHERE IDShakhs NOT IN (SELECT IDShakhs FROM AshkhasList)
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

-----------afzodane Pardakht hayi ke dar factor sabt shode ast
IF @@TRANCOUNT = 1
INSERT INTO Pardakht(CodePardakht, [Date], Price, [Time], TypeCodePardakht, Takhfif, FactorId)
SELECT Factor1.IDShakhs,Factor1.[Date], tbl2.Price,
CONVERT(varchar,DATEADD(ss,2,CONVERT(datetime,Factor1.[Time])),108) AS [Time],
0 AS Type,0 AS Takhfif, Factor1.[ID]
FROM Factor1 INNER JOIN
(SELECT [Date],[No],[Type],SUM(Price) AS Price FROM (
SELECT FactorDate AS [Date],FactorID AS [No],FactorType AS [Type], Price
FROM tblPardakht
WHERE NOT FactorID IS NULL
UNION ALL
SELECT DateFactor AS [Date],FactorNo AS [No],FactorType AS [Type], Price
FROM SodorInfo
WHERE NOT FactorNo IS NULL) tbl
GROUP BY [Date],[No],[Type]) tbl2
ON Factor1.Type=tbl2.Type AND Factor1.[Date]=tbl2.[Date] AND Factor1.FactorNo=tbl2.[no]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
INSERT INTO Pardakht2([PardakhtID], [Price], [SandooghHesab], [BankID], [Info])
SELECT Pardakht.[ID],tblPardakht.Price,Sandoogh_Code, HesabBankID,tblPardakht.Info
FROM tblPardakht INNER JOIN Factor1 on factor1.factorno=tblPardakht.factorid and
		factor1.date=tblPardakht.factordate and factor1.type=tblPardakht.factortype
INNER JOIN Pardakht ON Pardakht.FactorID=Factor1.[ID]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
DELETE FROM tblPardakht WHERE NOT FactorID IS NULL
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
INSERT INTO Pardakht2([PardakhtID], [Price], [SodorID])
SELECT Pardakht.[ID],SodorInfo.Price,SodorInfo.[ID]
FROM SodorInfo INNER JOIN Factor1 on factor1.factorno=SodorInfo.factorno and
		factor1.date=SodorInfo.dateFactor and factor1.type=SodorInfo.factortype
INNER JOIN Pardakht ON Pardakht.FactorID=Factor1.[ID]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 
UPDATE SodorInfo SET Pardakht2ID=(SELECT [ID] FROM Pardakht2 WHERE SodorID=SodorInfo.[ID])
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
begin
	print 'update Pardakht'
	insert into Pardakht(codePardakht,date,time,typecodePardakht,SanadNo,price,info)
	select tblPardakht.idshakhs,tblPardakht.date,tblPardakht.time,0,tblPardakht.sanadno,tblPardakht.price,tblPardakht.info from tblPardakht
end
Go
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1 UPDATE Pardakht SET Code=[ID]
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
begin
	print 'update Pardakht2'
	insert into Pardakht2 (Pardakhtid,price,info,sandooghhesab,bankid)
	select Pardakht.id,tblPardakht.price,tblPardakht.info,tblPardakht.sandoogh_code,tblPardakht.HesabBankID  from tblPardakht
	INNER JOIN Pardakht ON tblPardakht.[Date]=Pardakht.[Date] AND tblPardakht.[Time]=Pardakht.[Time] AND tblPardakht.[Price]=Pardakht.[Price]
end
Go
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

----------------------------------------------------------------------------------
IF @@TRANCOUNT = 1
	BEGIN
		drop table tblPardakht
		drop table tblDaryaft
	END
Go
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
exec('ALTER VIEW dbo.AllSandoogh
AS
SELECT     tbl.CodeHesab, dbo.Sarfaslhesab_tafzili.Name
FROM         (SELECT     Sandoogh1 AS CodeHesab
				FROM         Setting
				UNION
				SELECT     Sandoogh2 AS CodeHesab
				FROM         Setting
				UNION
				SELECT DISTINCT SandooghHesab AS CodeHesab
				FROM         Daryaft2
				WHERE     NOT SandooghHesab IS NULL
				UNION
				SELECT DISTINCT SandooghHesab AS CodeHesab
				FROM         Pardakht2
				WHERE     NOT SandooghHesab IS NULL
				UNION
				SELECT DISTINCT SandooghHesab AS CodeHesab
				FROM         tblHazine2
				WHERE     NOT SandooghHesab IS NULL
				UNION
				SELECT DISTINCT codehesab AS CodeHesab
				FROM         tbldaramad
				WHERE     type = 2
				UNION
				SELECT DISTINCT Bar_Sandoogh AS CodeHesab
				FROM         EnteghalVajh
				UNION
				SELECT DISTINCT Var_Sandoogh AS CodeHesab
				FROM         EnteghalVajh) tbl
INNER JOIN dbo.Sarfaslhesab_tafzili ON tbl.CodeHesab = dbo.Sarfaslhesab_tafzili.Codehesab')
GO
IF @@ERROR <> 0 IF @@TRANCOUNT = 1 ROLLBACK TRANSACTION
GO

IF @@TRANCOUNT = 1
BEGIN
   PRINT 'Successfull'
   COMMIT TRANSACTION
END ELSE PRINT 'Failed'