unit CPosInterface;

interface

type
  TPosInterface = class
  private
    FMessageID: Integer;
    FIPAddress: String;
    FPortNo: Integer;

  public
    procedure CallbackPayment(aResponse: PChar);
    function DoBillPayment(aPaymentIds: String; aBillIds: String; aTimeout: Integer; var aResponse: String): Integer;
    function DoPayment(aPaymentAmount: Integer; aTashim, aInvoiceNumber: String; aTimeout: Integer; var aResponse: String): Integer;

  public
    property MessageID: Integer read FMessageID write FMessageID;
    property IPAddress: String read FIPAddress write FIPAddress;
    property PortNo: Integer read FPortNo write FPortNo default 17000;
  end;

implementation
uses
  SysUtils, Dialogs;

const
  DLLPATH = '..\PcPos\Debug\PcPos.dll';

type
  PResponseCallback = ^TResponseCallback;
  TResponseCallback = procedure(aResponse: PChar);

function DllBillPayment(aMessageID: Integer; aPaymentIds, aBillIds: PChar;
  aDateTime, aIPAdress: PChar;
  aPortNo, aTimeout: Integer; aResponse: PByteArray; aResponseMaxLen: Integer;
  var aSocketLastError: Integer;
  aCallbackFunc: TResponseCallback): Integer; stdcall; external DLLPATH name 'BillPayment';

function DllPayment(aMessageID: Integer; aPaymentAmount: Integer; aTashim, aInvoiceNumber: PChar;
  aDateTime, aIPAdress: PChar;
  aPortNo, aTimeout: Integer; aResponse: PByteArray; aResponseMaxLen: Integer;
  var aSocketLastError: Integer;
  aCallbackFunc: TResponseCallback): Integer; stdcall; external DLLPATH name 'Payment';

procedure CallbackPayment1(aResponse: PChar);
begin
  MessageDlg(aResponse, mtInformation, mbOKCancel, 0);
end;


{ TPosInterface }
procedure TPosInterface.CallbackPayment(aResponse: PChar);
begin
end;

function TPosInterface.DoBillPayment(aPaymentIds: String; aBillIds: String; aTimeout: Integer; var aResponse: String): Integer;
begin
end;

function TPosInterface.DoPayment(aPaymentAmount: Integer; aTashim, aInvoiceNumber: String; aTimeout: Integer; var aResponse: String): Integer;
var
  vResponse: array[0..4096] of Byte;
  vSocketLastError: Integer;
  vResult: Integer;
  vNow: TDateTime;
  vDateTime: String;
begin

  //raise Exception.CreateFmt('', []);
  if IPAddress = '' then raise Exception.Create('IPAddress not initialized');
  if PortNo = 0 then raise Exception.Create('Port number not initialized');

  Inc(FMessageID);
  aResponse := '';
  FillChar(vResponse, SizeOf(vResponse), 0);
  vSocketLastError := 0;
  vNow := GetTime;
  vDateTime := FormatDateTime('yyyyMMddhhmmss', vNow);
  vResult := DllPayment(MessageID, aPaymentAmount, PAnsiChar(aTashim), PAnsiChar(aInvoiceNumber), PAnsiChar(vDateTime)
      , PAnsiChar(Self.IPAddress), Self.PortNo, aTimeout, @vResponse, SizeOf(vResponse), vSocketLastError, CallbackPayment1);
  if (vResult = 0) then
      aResponse := PChar(@vResponse)^;
  Result := vResult;
end;

{
    if (string.IsNullOrEmpty(IPAddress)) throw new Exception("IPAddress not initialized");
    if (PortNo == 0) throw new Exception("Port number not initialized");

    MessageID += 1;
    aResponse = "";
    byte[] vResponse = new byte[4096];
    int vSocketLastError;
    int vResult = Payment(MessageID, aPaymentAmount, aTashim, aInvoiceNumber, DateTime.Now.ToString("yyyyMMddhhmmss")
        , this.IPAddress, this.PortNo, aTimeout, vResponse, vResponse.GetLength(0), out vSocketLastError, CallbackPayment);
    if (vResult == 0)
        aResponse = ASCIIEncoding.ASCII.GetString(vResponse);
    return vResult;
}


end.
