unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, UPosInterface, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    txtIPAddress: TEdit;
    Label2: TLabel;
    txtPortNo: TEdit;
    btnInit: TButton;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    txtPaymentAmount: TEdit;
    txtInvoiceNumber: TEdit;
    btnDoPayment: TButton;
    Label5: TLabel;
    txtTashim: TEdit;
    GroupBox3: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    txtPaymentIDs: TEdit;
    txtBillIDs: TEdit;
    btnDoBillPayment: TButton;
    lsbResult: TListBox;
    pnlExecution: TPanel;
    pbrElapsedTime: TProgressBar;
    btnCancelExecution: TButton;
    btnClear: TButton;
    tmrElapsedTime: TTimer;

    procedure PosInterface_PaymentResponse(sender: TObject; e: TPosEventArgs);
    procedure PosInterface_BillPaymentResponse(sender: TObject; e: TPosEventArgs);
    procedure btnDoPaymentClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnInitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCancelExecutionClick(Sender: TObject);
    procedure tmrElapsedTimeTimer(Sender: TObject);
    procedure btnDoBillPaymentClick(Sender: TObject);
  private
    { Private declarations }
    aResponse: PByteArray;
    FPosInterface: TPosInterface;

    procedure InitPosInterfaceParams();
    procedure BeforePay();
    procedure AfterPay(aRetValue: Integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.InitPosInterfaceParams();
var
  vPortNo: Integer;
begin
  FPosInterface.IPAddress := txtIPAddress.Text;
  vPortNo := StrToInt(txtPortNo.Text);
  if vPortNo > 0 then
    FPosInterface.PortNo := vPortNo;
end;

procedure TForm1.BeforePay();
begin
  if FPosInterface.IsExecuted then
    Exit;

  pbrElapsedTime.Position := 0;
  pbrElapsedTime.Min := 0;
  pbrElapsedTime.Max := 100;
  pnlExecution.Visible := True;
  tmrElapsedTime.Interval := 1000;
  tmrElapsedTime.Enabled := True;
end;

procedure TForm1.AfterPay(aRetValue: Integer);
begin
  if (EnumResponseResult(aRetValue) = ERR_PAY_INEXECUTION) then
    Exit;

  tmrElapsedTime.Enabled := False;
  pnlExecution.Visible := False;
end;

procedure TForm1.PosInterface_PaymentResponse(sender: TObject; e: TPosEventArgs);
begin
  lsbResult.AddItem(e.ToString, nil);
end;

procedure TForm1.PosInterface_BillPaymentResponse(sender: TObject; e: TPosEventArgs);
begin
  lsbResult.AddItem(e.ToString, nil);
end;

procedure TForm1.btnDoPaymentClick(Sender: TObject);
var
  vResponse: String;
  vTimeout: Integer;
  r: Integer;
begin
  InitPosInterfaceParams;
  vTimeout := 60000;
  BeforePay;
  r := FPosInterface.DoPayment(StrToInt(txtPaymentAmount.Text), txtTashim.Text, txtInvoiceNumber.Text, vTimeout, vResponse);
  AfterPay(r);
  if (r <> 0) then
    lsbResult.AddItem(FPosInterface.GetResponseErrorMessage(r), nil);

end;

procedure TForm1.btnDoBillPaymentClick(Sender: TObject);
var
  vResponse: String;
  vTimeout: Integer;
  r: Integer;
begin
  InitPosInterfaceParams;
  vTimeout := 60000;
  BeforePay;
  //aPaymentIds: String; aBillIds: String; aTimeout: Integer; var aResponse: String
  r := FPosInterface.DoBillPayment(txtPaymentIds.Text, txtBillIds.Text, vTimeout, vResponse);
  AfterPay(r);
  if (r <> 0) then
    lsbResult.AddItem(FPosInterface.GetResponseErrorMessage(r), nil);

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FPosInterface := TPosInterface.Create;
  FPosInterface.OnPaymentResponse := PosInterface_PaymentResponse;
  FPosInterface.OnBillPaymentResponse := PosInterface_BillPaymentResponse;
  btnInitClick(btnInit);
end;

procedure TForm1.btnInitClick(Sender: TObject);
begin
  FPosInterface.IPAddress := txtIPAddress.Text;
  FPosInterface.PortNo := StrToInt(txtPortNo.Text);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FPosInterface.Free;
end;

procedure TForm1.btnCancelExecutionClick(Sender: TObject);
begin
  FPosInterface.CancelExecution()
end;

procedure TForm1.tmrElapsedTimeTimer(Sender: TObject);
begin
  pbrElapsedTime.Position := FPosInterface.PercentElapsedTime
end;

end.
