<?php
 // SIBA SHOP API Module version 1.4.7
 
   $version="1.4.7"; //IMPORTANT
     
   set_time_limit(600); // 10 minutes
   ini_set('max_execution_time', 600);

   /* ApiSetting.ini
   [writeLog]
    logEnabled=1
    writeMode = "a"
	logType=timer,images,result
   [url]
	subdomain = "/xxxxxxxx"
	[gateways]
	cod = Digikala
   */
   
  $ApiSetting = array();
  $ApiSetting = @parse_ini_file('ApiSetting.ini');
  
  $logEnabled = (isset($ApiSetting['logEnabled'])) ?  $ApiSetting['logEnabled'] : 0;
  $logType= (isset($ApiSetting['logType'])) ?  $ApiSetting['logType'] : "";
  $cod = (isset($ApiSetting['cod'])) ?  $ApiSetting['cod'] : "";
  
  if(isset($ApiSetting['writeMode']) && ($ApiSetting['writeMode'] == 'a' || $ApiSetting['writeMode'] == 'w'))
  $writeMode = $ApiSetting['writeMode']; //changed 1.4.7
  //echo $writeMode;
  //ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
  (isset($ApiSetting['subdomain']) && strlen($ApiSetting['subdomain'])> 3) ? $subdomain = $ApiSetting['subdomain'] : $subdomain = "";

	
	 function writeLog($txt,$writeMode="w",$filename="log.txt"){
		 date_default_timezone_set("Asia/Tehran");
		 $myfile = fopen($filename, $writeMode) or die("Unable to open file!");
		 //$txt = mb_convert_encoding($txt, 'UTF-8');
		 fwrite($myfile, $txt.":".date("Y-m-d H:i:s")."\n");
		 fclose($myfile);
	 }
	 
	 function convertePersianNums($s){	
       $num = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9','9', '8', '7', '6', '5', '4', '3', '2', '1', '0'];
       $persian = ['?', '?', '?', '?', '?', '?', '?', '?', '?', '?','9', '8', '7', '6', '5', '4', '3', '2', '1','0'];
       return str_replace($persian, $num, $s);
    }
	 
	// if($_POST['action'] != 'images')
	 if($logEnabled && strpos($logType,'timer') !==false)
	 writeLog($_POST['action'].":".$_POST['items'].$_POST['statuses'],$writeMode,$filename="timer.txt");
	 
	 function cPrice($price,$sC,$tC){ // $sC واحد پولي مبدا / $tC واحد پولي مقصد
	 
		convertePersianNums($price);
		$price= preg_replace('/[^0-9]/', '', $price);
		
		if($sC==$tC){
			return $price;
		}else{
		
		$ceExc = substr($sC,-(strlen($sC)-2))."-".substr($tC,-(strlen($tC)-2));
		
		switch($ceExc){
		case "R-T":
		$price=round($price/10);
		break;
		case "R-HR":
		$price=round($price/1000);
		break;
		case "R-HT":
		$price=round($price/10000);
		break;
		case "T-R":
		$price=round($price*10);
		break;
		case "T-HR":
		$price=round($price/100);
		break;
		case "T-HT":
		$price=round($price/1000);
		break;
		case "HR-R":
		$price=round($price*1000);
		break;
		case "HR-T":
		$price=round($price*100);
		break;
		case "HR-HT":
		$price=round($price/10);
		break;
		case "HT-R":
		$price=round($price*10000);
		break;
		case "HT-T":
		$price=round($price*1000);
		break;
		case "HT-HR":
		$price=round($price*10);
		break;
		}
		return $price;
		}
		
	}
  
  	require __DIR__ . '/vendor/autoload.php';
	
	use Automattic\WooCommerce\Client;
	use Automattic\WooCommerce\HttpClient\HttpClientException;

  $items=array();
    
  if(isset($_POST['items']))
  $items=json_decode(convertePersianNums($_POST['items']));
  elseif(isset($_POST['statuses']))
  $items=json_decode($_POST['statuses']);
  
  $op=strtolower(trim($_POST['action']));
  
   require( '../wp-load.php' );
  
  if($op=='authorization'){ // check User API CK & CS
  
    $apiCK=hash_hmac('sha256',trim($_POST['apiCK']),'wc-api');
    $DB_HOST=explode(":", DB_HOST)[0]; // remove port number if exist
	$conn = new mysqli($DB_HOST, DB_USER, DB_PASSWORD,DB_NAME);
	
	$result = $conn->query("SELECT * FROM ".$table_prefix."woocommerce_api_keys WHERE consumer_key = '".$apiCK."' AND consumer_secret = '".trim($_POST['apiCS'])."'");
	if($result->num_rows)
	echo '{"result":true}';
	else
	echo '{"result":false}';
	
 }elseif($op=='images'){

     $uploads_dir="./uploads";
     if (!file_exists($uploads_dir)) {
            mkdir($uploads_dir, 0777, true);
        }
     function checkExt($filename){
     $valid_ext = array("png","jpeg","jpg","gif","bmp","webp");
     $ext = pathinfo($filename, PATHINFO_EXTENSION);
     if(in_array($ext, $valid_ext))
     return true;
     else
     return false;
    }
     
    foreach ($_FILES["images"]["tmp_name"] as $key => $val) {
            $tmp_name = $_FILES["images"]["tmp_name"][$key];
            $name = $_FILES["images"]["name"][$key];
			
            //if($logEnabled && strpos($logType,'timer') !==false)
            //writeLog($_POST['action'].":".$name,$writeMode,$filename="timer.txt");
            
            if(strlen(trim($name)) < 3)
            break;
            if(checkExt($name)){
            if(move_uploaded_file($tmp_name, "$uploads_dir/".$name))
            echo '{"result":"success"}';
            else
            echo '{"result":"failed"}';
            }else{
            echo '{"result":"extension is not valid"}'; 
            }
            
    }
 }elseif($op=='info'){
	//get Server Time & Woocommerce Currency Symbol
	echo json_encode(array('serverTime'=>time(),'serverCurrency'=>get_woocommerce_currency(),'serverVersion'=>preg_replace('/[^0-9]/', '', $version))); //changed 1.4.7
	
 }elseif(count($items) || $op=='orders' || $op=='orderscount'){
		
	$storeUrl = parse_url(trim($_POST['storeUrl']));
	$domain = $storeUrl['host'];
    preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs);
    $storeUrl="https://".$regs['domain'].$subdomain; //changed 1.4.7

	
	$client = new Client(
		$storeUrl,
		$_POST['apiCK'],
		$_POST['apiCS'],
		[
			'wp_api' => true,
			'timeout' => 300,
			'version' => 'wc/v3'
		]
	);


try {

if($op=='orderstatus'){
    
    // check valid status *****
    
    if(count($items)>50)
    $items=array_slice($items, 0, 50);
    
	$orderIds = array();
	
	foreach($items as $item){
			
	$data = [
    'status' => $item->Status
	];
	
	$order=$client->put('orders/'.$item->eshopID, $data);	
	$orderIds[]=array('eshopID' => $order->id);

	}
	
	echo json_encode($orderIds);
	
}elseif($op=='orderscount'){
	
	/*$data = [
    'status' => $_POST['status'],
    'per_page' => 100
	];*/
	$oCount=0;
	$i=1;
	
	function orderscount ($i,$status) {		
		$orders=array();
        $orders= $client->get('orders',['page'=>$i,'per_page'=>100,'status'=>$status]);
		$i++;
	 	if(count($orders)<100)
	 	 return $oCount+=count($orders);
		orderscount($i,$status);
	}
	
	  echo "{'count':'".orderscount($i,$_POST['status'])."'}";
		 	
}elseif($op=='orders'){

	if(trim($_POST['orderID'])>0){
	$accCurrency  = $_POST['currencyType']; // واحد پولي حسابداري
	$serverCurrency = get_woocommerce_currency();  // واحد پولي ووکامرس

	$order = $client->get('orders/'.trim($_POST['orderID']));
	
	$forders = array();
	    
	    $forders['id']=$order->id;
	    $forders['date_created']=$order->date_created;
	    $forders['date_modified']=$order->date_modified;
	    
	    $forders['discount_total']=cPrice($order->discount_total,$serverCurrency,$accCurrency);
	    //$forders['subtotal']=cPrice($order->subtotal,$serverCurrency,$accCurrency); changed
	    $forders['total']=cPrice($order->total,$serverCurrency,$accCurrency);
	    $forders['total_tax']=cPrice($order->total_tax,$serverCurrency,$accCurrency);
	    
	    $forders['customer_id']=$order->customer_id; 
	    
	    if(count($order->shipping_lines)){
	     $shipping_total=$order->shipping_lines[0]->total;
	     $shipping_methods=$order->shipping_lines[0]->method_title;
	    }else{
	     $shipping_total=0;
	     $shipping_methods='';  
	    }
	    
	    $forders['shipping_total']=cPrice($shipping_total,$serverCurrency,$accCurrency); //changed
	    $forders['shipping_methods']=$shipping_methods;
		
	    $customerInfo=$order->billing;
	    $forders['customer_info']['first_name']=convertePersianNums($customerInfo->first_name);
	    $forders['customer_info']['last_name']=convertePersianNums($customerInfo->last_name);
	    $forders['customer_info']['company']=convertePersianNums($customerInfo->company);
	    $forders['customer_info']['address']=convertePersianNums($customerInfo->address_1." ".$customerInfo->address_2); //changed
	    $forders['customer_info']['city']=convertePersianNums($customerInfo->city);
	    ($customerInfo->state == 'چهارمحال بختياري' || $customerInfo->state == 'چهار محال بختياري') ? $forders['customer_info']['state']='چهارمحال و بختياري' : $forders['customer_info']['state']=$customerInfo->state;
	    $forders['customer_info']['postcode']=convertePersianNums($customerInfo->postcode);
	    $forders['customer_info']['email']=convertePersianNums($customerInfo->email);
	    $forders['customer_info']['phone']=convertePersianNums($customerInfo->phone);
	    
	    
        $forders['payment_method']=$order->payment_method;
        $forders['payment_method_title']=$order->payment_method_title;
        $forders['payment_total']=cPrice($order->total,$serverCurrency,$accCurrency); //changed
        $forders['transaction_id']=$order->transaction_id;
        $forders['date_paid']=$order->date_paid;
        
        $forders['note']=convertePersianNums($order->customer_note);
        
	   	$items=$order->line_items;

		foreach($items as $ikey =>  $item){
		    
		  $forders['line_items'][$ikey]['code']=convertePersianNums($item->sku);
		  $forders['line_items'][$ikey]['name']=convertePersianNums($item->name);
		  $forders['line_items'][$ikey]['price']=cPrice(round($item->subtotal/$item->quantity),$serverCurrency,$accCurrency);
		  $forders['line_items'][$ikey]['quantity']=$item->quantity;
		  $forders['line_items'][$ikey]['discount_item']=cPrice(round($item->subtotal-$item->total),$serverCurrency,$accCurrency);
		  $forders['line_items'][$ikey]['subtotal']=cPrice($item->total,$serverCurrency,$accCurrency);
  
    		  $metas=$item->meta_data;
		  
		  	foreach($metas as $mkey =>  $meta){
		  	    
		  	    if($meta->key!='_reduced_stock'){
		  	    $forders['line_items'][$ikey]['meta'][$mkey]['key']=convertePersianNums($meta->key);
		  	    $forders['line_items'][$ikey]['meta'][$mkey]['label']=convertePersianNums($meta->display_key);
				$forders['line_items'][$ikey]['meta'][$mkey]['value']=convertePersianNums($meta->display_value);
		  	    //$forders['line_items'][$ikey]['meta'][$mkey]['value']=$meta->value;
		  	    }
		  	    
		  	}
		    
		}
	    
	
	echo json_encode($order);
	echo "\n\r------------------------------------\n\r";
	echo json_encode($forders);
	
	}else{
    
	$accCurrency  = $_POST['currencyType']; // واحد پولي حسابداري
	$serverCurrency = get_woocommerce_currency();  // واحد پولي ووکامرس
	
	$data = [
	'per_page' => $_POST['limitOrders'],
	'order' => 'asc',
    'status' => $_POST['status']
	];
	
	
	$orders = $client->get('orders',$data);
	
	$forders = array();
	
	foreach($orders as $okey => $order){
	    
	    $forders[$okey]['id']=$order->id;
	    $forders[$okey]['date_created']=$order->date_created;
	    $forders[$okey]['date_modified']=$order->date_modified;
	    
	    $forders[$okey]['discount_total']=cPrice($order->discount_total,$serverCurrency,$accCurrency);
	    //$forders[$okey]['subtotal']=cPrice($order->subtotal,$serverCurrency,$accCurrency); changed
	    $forders[$okey]['total']=cPrice($order->total,$serverCurrency,$accCurrency);
	    $forders[$okey]['total_tax']=cPrice($order->total_tax,$serverCurrency,$accCurrency);
	    
	    $forders[$okey]['customer_id']=$order->customer_id; 
	    
	    if(count($order->shipping_lines)){
	     $shipping_total=$order->shipping_lines[0]->total;
	     $shipping_methods=$order->shipping_lines[0]->method_title;
	    }else{
	     $shipping_total=0;
	     $shipping_methods='';  
	    }
	    
	    $forders[$okey]['shipping_total']=cPrice($shipping_total,$serverCurrency,$accCurrency); //changed
	    $forders[$okey]['shipping_methods']=$shipping_methods;
	    
	    $customerInfo=$order->billing;
	    $forders[$okey]['customer_info']['first_name']=convertePersianNums($customerInfo->first_name);
	    $forders[$okey]['customer_info']['last_name']=convertePersianNums($customerInfo->last_name);
	    $forders[$okey]['customer_info']['company']=convertePersianNums($customerInfo->company);
	    $forders[$okey]['customer_info']['address']=convertePersianNums($customerInfo->address_1." ".$customerInfo->address_2); //changed
	    $forders[$okey]['customer_info']['city']=convertePersianNums($customerInfo->city);
		($customerInfo->state == 'چهارمحال بختياري' || $customerInfo->state == 'چهار محال بختياري') ? $forders[$okey]['customer_info']['state']='چهارمحال و بختياري' : $forders[$okey]['customer_info']['state']=$customerInfo->state;
	    $forders[$okey]['customer_info']['postcode']=convertePersianNums($customerInfo->postcode);
	    $forders[$okey]['customer_info']['email']=convertePersianNums($customerInfo->email);
	    $forders[$okey]['customer_info']['phone']=convertePersianNums($customerInfo->phone);
	    
		if(strlen($cod) && strpos(strtolower($cod), $order->payment_method) !== false)
        $forders[$okey]['payment_method']="cod";
        else
        $forders[$okey]['payment_method']=$order->payment_method;

        $forders[$okey]['payment_method_title']=$order->payment_method_title;
        $forders[$okey]['payment_total']=cPrice($order->total,$serverCurrency,$accCurrency); //changed
        $forders[$okey]['transaction_id']=$order->transaction_id;
        $forders[$okey]['date_paid']=$order->date_paid;
        
        $forders[$okey]['note']=convertePersianNums($order->customer_note);
        
	   	$items=$order->line_items;

		foreach($items as $ikey =>  $item){
		   
		$forders[$okey]['line_items'][$ikey]['code']=convertePersianNums($item->sku);
		$forders[$okey]['line_items'][$ikey]['name']=convertePersianNums($item->name);
		$forders[$okey]['line_items'][$ikey]['price']=cPrice(round($item->subtotal/$item->quantity),$serverCurrency,$accCurrency);
		$forders[$okey]['line_items'][$ikey]['quantity']=$item->quantity;
		$forders[$okey]['line_items'][$ikey]['discount_item']=cPrice(round($item->subtotal-$item->total),$serverCurrency,$accCurrency);
		$forders[$okey]['line_items'][$ikey]['subtotal']=cPrice($item->total,$serverCurrency,$accCurrency);
    		  
    		$metas=$item->meta_data;
		  
		  	foreach($metas as $mkey =>  $meta){
		  	    
		  	    if($meta->key!='_reduced_stock'){
		  	    $forders[$okey]['line_items'][$ikey]['meta'][$mkey]['key']=convertePersianNums($meta->key);
		  	    $forders[$okey]['line_items'][$ikey]['meta'][$mkey]['label']=convertePersianNums($meta->display_key);
				$forders[$okey]['line_items'][$ikey]['meta'][$mkey]['value']=convertePersianNums($meta->display_value);
		  	    //$forders[$okey]['line_items'][$ikey]['meta'][$mkey]['value']=$meta->value;
		  	    }
		  	    
		  	}
		    
		}
	    
	}
	
	echo json_encode($forders);
		
	 }
	
	}elseif($op=='cats'){
		 
		 function removeElementWithValue($array, $value){
		 $key = array_search($value, $array);
		 unset($array[$key]);
		 return $array;
	}

$cats=get_terms(array( 'taxonomy' => 'product_cat','hide_empty' => false ));
$cats_a=[];
foreach($cats as $cat){
	$cats_a[]= $cat->term_id;
}
unset($cats);

foreach($items as $item){	
    
	$parent_term_id =0;
	
	if(strlen($item->parent_name)>0){

	if($parent_term_a = term_exists($item->parent_name, 'product_cat',NULL)){
     $parent_term_id= $parent_term_a['term_id'];
	 }else{
	 // Create the Parent category
	 $wpdocs_parent = array('parent' => $parent_term_id);
	 $parent_term_a = wp_insert_term($item->parent_name,'product_cat',$wpdocs_cat);
     $parent_term_id = $parent_term_a['term_id'];
	 }
	}
	
	if($cat_a = term_exists( $item->name, 'product_cat',$parent_term_id)){
	 $cats_a=removeElementWithValue($cats_a, $cat_a['term_id']);
	}else{
	// Create the category with ParentID
	$wpdocs_cat = array('parent' => $parent_term_id);
	$wpdocs_cat_id = wp_insert_term($item->name,'product_cat',$wpdocs_cat);
	
	}	
}  

foreach( $cats_a as $cat ) {
   wp_delete_term($cat,'product_cat');
}

    echo '{"result":"success"}';

    }elseif($op=='productsinfo'){
	
	$accCurrency  = $_POST['currencyType']; // واحد پولي حسابداري
	$serverCurrency = get_woocommerce_currency();  // واحد پولي ووکامرس	
	
	$products = $items;
	
	$productsInfo=array();
	
	foreach($products as $key => $item){
		 
		$code = [
			'sku' => trim($item->Code)
		];
				
		$productID=0;
				 
		if($product=$client->get('products',$code)){
			$productID=$product[0]->id;
		}
				
		if($productID>0){	
		
		$productInfo=$client->put('products/'.$productID);

		foreach($productInfo as $info){
		
		$productsInfo[]['code']=convertePersianNums($info->sku);
		$productsInfo[]['price']=cPrice($info->price,$serverCurrency,$accCurrency);
		$productsInfo[]['stock']=convertePersianNums($info->stock_quantity);
		$productsInfo[]['status']=$info->status;
		
			}		
		}
	}
	
	 echo json_encode($productsInfo);
	 
    }elseif($op=='products'){
		
	$accCurrency  = $_POST['currencyType']; // واحد پولي حسابداري
	$serverCurrency = get_woocommerce_currency();  // واحد پولي ووکامرس	
	
	
	function retCatID($cname,$pcname){
	$parent_term_id=0;
	if(strlen($pcname)>0){
		if($parent_term_a = term_exists($pcname, 'product_cat',NULL)){
		 $parent_term_id= $parent_term_a['term_id'];
	}
		}
	$cat_a = term_exists($cname,'product_cat',$parent_term_id);	
	return $cat_a['term_id'];	
	}
	
		function addAttributes($attrID,$type,$value){  // add attribute or terms if not exist 
		
		global $client,$colors,$sizes;
		
		if(!$attrID){
		$data = [
		'name' => ($type == 'colors') ? 'رنگ' : 'سايز',
		'slug' => $type
		];
		$attr=$client->post('products/attributes', $data);
		$attrID=$attr->id;
		}
		
		${$type."ID"}=$attrID;
		
		$data = [
		'name' => $value
		];
		
		$term=$client->post('products/attributes/'.$attrID.'/terms', $data);	
		
		${$type}[$term->id]=$value;
		  
		}
		
		function ret_varID($val,$type,$avar) {
		    
			  foreach($avar as $var){
			   
			    if($type == 'sc'){
			        $vid=0;
			       foreach($var['attrs'] as $attr){
			        if($attr['attr_name'] == 'sizes' && $attr['attr_option'] == $val['size'] || $attr['attr_name'] == 'colors' && $attr['attr_option'] == $val['color'])
			        $vid+=1;
			       }
			       if($vid == 2)
			       return $var['id'];
			       
			    }else{
			        
			       foreach($var['attrs'] as $attr){
			         if($attr['attr_name'] == $type && $attr['attr_option'] == $val)  
			       return $var['id'];
			       
			    }
				
			 }	  
				  
				}
				return false;
		}
			 
		function updateProVar($pid,$vid,$data){
				global $client;
				$client->put('products/'.$pid.'/variations/'.$vid, $data);	 
		 }
			 
		function createProVar($pid,$data){
				global $client;
				$client->post('products/'.$pid.'/variations/', $data);			 
		}

		
		function checkImgByName($pimages,$img){
		    
		foreach($pimages as $key => $pimage){
		  if (strpos($pimage->src,$img))
			return array($pimage->id,$key);
		  }
		  
		  return array(0,0);
		}

		$colors=array();
		$colorsID=0;
		$sizes=array();
		$sizesID=0;
		
	$product_attributes=$client->get('products/attributes');
	
	foreach($product_attributes as $key => $attr){
		
	    if(strpos($attr->name,"رنگ")!==false || strpos($attr->name,"color")!==false || strpos($attr->slug,"color")!==false){
		$colorsID=$attr->id;
		$vslug='colors';
		}
		elseif(strpos($attr->name,"سايز")!==false || strpos($attr->name,"اندازه")!==false || strpos($attr->name,"size")!==false || strpos($attr->slug,"size")!==false){
		$sizesID=$attr->id;
		$vslug='sizes';
		} 
		else
		$vslug=$attr->slug;
		

		for ($i = 1; $i <= 5; $i++) {
		
		$attribute_terms=array();
		
	    $attribute_terms=$client->get('products/attributes/'.$attr->id.'/terms',['page'=>$i,'per_page'=>100]);
		
		
	    foreach($attribute_terms as $key => $term){
			
		${$vslug}[]=$term->name;  
		 
	 	  }	
	 	  
	 	  if(count($attribute_terms)<100)
	 	  break;
		  
		 }
		  
		}

			$products = $items;
			//unset($data);
			
			$images=array();
			
			$productsExport=array(); 
			
			// For Wholesale Price
			$hasWPrice=false;
			$productsWprices=array();
			
			foreach($products as $key => $item){
			
			/*if(isset($item->Price) && !(cPrice($item->Price,$accCurrency,$serverCurrency)>0)){
			$productsExport[]=array('id' => null ,'code' => $item->Code);
			continue;
			}*/
			
	 		$pro_images=array(); // changed 1.4.7
				
			$code = [
			  'sku' => trim($item->Code)
			];
			
			$productID=0;
			 
			if($product=$client->get('products',$code)){
			$productID=$product[0]->id;
			}
			
			if(!$productID && $_POST['umode']=="true"){ //changed 1.4.0
			$productsExport[]=array('id' => null ,'code' => $item->Code);
			continue;
			}
			
			$data = array();
			
			if($productID>0){
			if($_POST['editProductName']=="true"){
			$data['name']=trim($item->Name);
			$data['slug']=($product[0]->slug !== str_replace(" ","-",$product[0]->name)) ? $product[0]->slug : trim($item->Name);
			}
			$pro_images=$product[0]->images;
			}else{
			$data['name']=trim($item->Name);
			}
			
			if(!$productID && !$item->Status){
			$productsExport[]=array('id' => null ,'code' => $item->Code);  //changed 1.3.9
			continue;
			}
			
			if(!$productID && $item->Status && isset($_POST['newProductStatus']))
			$data['status'] = $_POST['newProductStatus'];
			elseif($productID && !$item->Status)
			$data['status'] = 'draft';
			
			if(count($item->attributes))
			$data['type'] = 'variable';
			
			$data['sku']=trim($item->Code);
			
			if(!is_null(trim($item->Info)) && strlen(trim($item->Info))>4)
			$data['description']=trim($item->Info);
			
			if(!is_null(trim($item->Info)) && strlen(trim($item->Info))>4)
			$data['short_description']=trim($item->Info);
			
			$data['manage_stock']=true;
			$data['stock_quantity']= ($item->Stock >= 0) ? floor($item->Stock) : 0;
			$data['stock_status']= ($item->Stock > 0) ? 'instock' : 'outofstock';
			
			if(isset($item->Price) && !count($item->attributes)){
			
			if($item->Price > 0){
			 $data['regular_price'] = "'".cPrice($item->Price,$accCurrency,$serverCurrency)."'";
			 $data['sale_price'] = "'".cPrice($item->FinalPrice,$accCurrency,$serverCurrency)."'";
			 }else{
			 $data['regular_price'] = '';
			 $data['sale_price'] = '';
			 } 
			 
			}
			
			if(isset($item->rWPrice)){
			 $WPrice = "'".cPrice($item->rWPrice,$accCurrency,$serverCurrency)."'";
			 $hasWPrice=true;
			}
				
			 if(isset($item->Gname)){
			 $catID=retCatID(trim($item->Gname),trim($item->GPname));
			 if($catID && !is_null($item->Gname)){
			 $data['categories'][]= array('id'=>$catID);
			 }
			}
			
			if(isset($item->Images)  && !is_null($item->Images)){
			    
			  $ar_images=explode(",", $item->Images); 
			  
			  $imgPath=array();
			  
			  if($logEnabled && strpos($logType,'images') !==false)
			  writeLog("code:".$data['sku']."|ar_images:".$item->Images,$writeMode,$filename="images.txt"); 
			  
				foreach($pro_images as $pimage){
				if($logEnabled && strpos($logType,'images') !==false)
				writeLog("code:".$data['sku']."|pro_imageID:".$pimage->id."|pro_imageSrc:".$pimage->src,$writeMode,$filename="images.txt"); 
				}
				
				if(count($pro_images))
				if($logEnabled && strpos($logType,'images') !==false)
				writeLog("----------------------------------------------",$writeMode,$filename="images.txt"); 
							  
			  foreach($ar_images as $image){
			   
			  list($imgID,$inx)=checkImgByName($pro_images,$image);
			  
			  if($imgID && file_exists('./uploads/'.$image)){
			  
			  $imgPath[]=array('id'=>$imgID,'src' => $storeUrl.'/api/uploads/'.$image);
			  $images[]=$image;
			  $itype=1;
			  }elseif($imgID && !file_exists('./uploads/'.$image)){  
			  
			  $imgPath[]= $pro_images[$inx];
			  $itype=2;
			  }elseif(!$imgID && file_exists('./uploads/'.$image)){
			  
			  $imgPath[]=array('src' => $storeUrl.'/api/uploads/'.$image);
			  $images[]=$image;
			  $itype=3;
			  }
			    if($logEnabled && strpos($logType,'images') !==false)
			  	writeLog("code:".$data['sku']."|type:".$itype."|imageID:".$imgID."|image:".$image,$writeMode,$filename="images.txt"); 
				
			    }
				
			  if($logEnabled && strpos($logType,'images') !==false)
			  writeLog("----------------------------------------------",$writeMode,$filename="images.txt");  
			  
              if(count($imgPath)){
			  $data['images'] = $imgPath;
			  
			  if($logEnabled && strpos($logType,'images') !==false)
			  writeLog("code:".$data['sku']."|type:".$itype."|imageID:".$imgID."|image:".$image,$writeMode,$filename="images.txt"); 
			  
			  }
			  
	    	}
			
			 // start create product attributes
			 
			 $pro_attributes=array();
			 
			 if(count($item->attributes)){
				 
			 $pro_attributes=$item->attributes;
			 
			 $attributes=array();
			 
			 $pro_colors=array();
			 $pro_sizes=array();
			 
			 foreach($pro_attributes as $attribute){
				if(isset($attribute->ColorName) && !is_null($attribute->ColorName)){	
				if(!in_array($attribute->ColorName,$pro_colors))
				$pro_colors[]=$attribute->ColorName;
				if(!in_array($attribute->ColorName,$colors))
				addAttributes($colorsID,'colors',$attribute->ColorName);
				}
				if(isset($attribute->SizeName) && !is_null($attribute->SizeName)){		
				if(!in_array($attribute->SizeName,$pro_sizes))
				$pro_sizes[]=$attribute->SizeName;
				if(!in_array($attribute->SizeName,$sizes))
				addAttributes($sizesID,'sizes',$attribute->SizeName);
				}
			 }
			 
			 if(count($pro_colors))
			 $attributes[]= array ('id' => $colorsID ,'variation' => true ,'options' => $pro_colors);
			 
			 if(count($pro_sizes))
			 $attributes[]= array ('id' => $sizesID ,'variation' => true ,'options' => $pro_sizes);
			 
			 $data['attributes'] = $attributes;
			 
			 }
			 
			 /************** default $attributes per product
			 if(count($pro_colors))
			 $data['default_attributes'][] = array('id' => $colorsID,'option' => $pro_colors[0]);
			 	 
			 if(count($pro_sizes))
			 $data['default_attributes'][] = array('id' => $sizesID,'option' => $pro_sizes[0]);
			 
			 *////////////////////////////////////////////////////////////////
			 
			 // end create product attributes
			 
			 $nproductID=0;
			 if($productID>0){	 
			 $nproduct=$client->put('products/'.$productID, $data);
			 }else{
			 $nproduct=$client->post('products', $data); 
			 $nproductID=$nproduct->id;
			 }
			 
			 $productsExport[]=array('id' => $nproduct->id,'code' => $nproduct->sku);
			 
			 // For Wholesale Price
			 if($hasWPrice)
			 $productsWprices[]=array('id' => $nproduct->id,'WPrice' => $WPrice);
			 //********************
			 
			 $pro_available_var=array(); //submited specs for existing product
			 
			 if(count($pro_attributes)){
			 
			 if($productID>0){
				 		 
				$pro_variations=$client->get('products/'.$productID.'/variations',['per_page'=>100]);
				
				 foreach($pro_variations as $variation){
				     
					$var_attrs=array();
					
				    foreach($variation->attributes as $var_attr){
						
						if(strpos($var_attr->name,"رنگ")!==false || strpos($attr->name,"color")!==false)
						$var_attrs[]=array('attr_id' => $var_attr->id, 'attr_name' => 'colors', 'attr_option' => $var_attr->option);
						elseif(strpos($var_attr->name,"سايز")!==false || strpos($var_attr->name,"اندازه")!==false || strpos($var_attr->name,"size")!==false)
						$var_attrs[]=array('attr_id' => $var_attr->id, 'attr_name' => 'sizes', 'attr_option' => $var_attr->option);
						else
						$var_attrs[]=array('attr_id' => $var_attr->id, 'attr_name' => $var_attr->name, 'attr_option' => $var_attr->option);
					   
					}
					    
					    $pro_available_var[]=array('id' => $variation->id, 'attrs' => $var_attrs);
						 
				 }
				
			 }
			 
			 
			 $available_varID=array();  // product specs from acc and exist IN submited product
			 
			 foreach($pro_attributes as $attribute){
			     
			  if($attribute->MojoodiSpec >= 0){  // for duplicate specs from Acc = -1
				 
				$attr_param = array();
				
			if((isset($attribute->SizeName) && !is_null($attribute->SizeName)) && (isset($attribute->ColorName) && !is_null($attribute->ColorName))){	
			
				$pro_attrs=array('color' => $attribute->ColorName,'size' => $attribute->SizeName);
				
				if($varID=ret_varID($pro_attrs,'sc',$pro_available_var))
				$available_varID[]=$varID;
				
				$attr_param[]=array('id' => $colorsID,'option' => $attribute->ColorName);
				$attr_param[]=array('id' => $sizesID,'option' => $attribute->SizeName);
				
			 }else{
			     
			  if((isset($attribute->SizeName) && !is_null($attribute->SizeName))){
				 
			    if($varID=ret_varID($attribute->SizeName,'sizes',$pro_available_var))
				$available_varID[]=$varID;	 
				
				$attr_param[]=array('id' => $sizesID,'option' => $attribute->SizeName);
				 
			 }
			 elseif((isset($attribute->ColorName) && !is_null($attribute->ColorName))){
				 
			    if($varID=ret_varID($attribute->ColorName,'colors',$pro_available_var))
				$available_varID[]=$varID;	 
				
				$attr_param[]=array('id' => $colorsID,'option' => $attribute->ColorName);
				 
			  }
			 }
		
			 
			 $data = array();

			 $data = [
			    'sku' => '', 
				'manage_stock' => true,
				'stock_quantity' => ($attribute->MojoodiSpec >= 0) ? floor($attribute->MojoodiSpec) : 0 ,
				'stock_status' => ($attribute->MojoodiSpec > 0) ? 'instock' : 'outofstock',
		        'regular_price' => (isset($item->Price) && $item->Price>0) ? "'".cPrice($item->Price,$accCurrency,$serverCurrency)."'" : '',
		        'sale_price' => (isset($item->FinalPrice) && $item->FinalPrice>0) ? "'".cPrice($item->FinalPrice,$accCurrency,$serverCurrency)."'" : '',
				'attributes' => $attr_param
			   ]; 
			 
			   if($nproductID>0)
			    $productID=$nproductID;				
			    if($varID>0)
			    updateProVar($productID,$varID,$data);
				else
				createProVar($productID,$data);			
			  }				
			 	}
			 	
			}
			  
			 // check  varitions id update and delete not update update ids 			
			 foreach($pro_available_var as $Dvar){
			    if(!in_array($Dvar['id'],$available_varID)){
			    $client->delete('products/'.$productID.'/variations/'.$Dvar['id'],['force' => true]);
			    }			 
			 }
			 				
			}
			
			
		foreach ($images as $image) {		
				if(!unlink('./uploads/'.$image)){
				if($logEnabled && strpos($logType,'images') !==false)
				writeLog("image:".$image,$writeMode,$filename="imageDEL.txt"); 	
				}				
		}
			
		if($hasWPrice){   
		foreach($productsWprices as $key => $meta){
			$proID=$meta['id'];
			echo $proID;
			update_post_meta($proID,'wholesale_customer_wholesale_price',$meta['WPrice']);
			($meta['WPrice']>0) ? $WPstatus='yes' : $WPstatus='no';
			update_post_meta($proID,'wholesale_customer_have_wholesale_price',$WPstatus);
		}
		}
		
		echo $result=json_encode($productsExport);
		
		if($logEnabled && strpos($logType,'result') !==false)
		 writeLog($result,$writeMode,$filename="result.txt");  
		  				
	   // }
	
	}
	
} catch (HttpClientException $e ) {

	$res=$e->getMessage() . PHP_EOL;
	$res=$e->getCode() . PHP_EOL;

	if ($e instanceof HttpClientException) {

		$res=$e->getRequest();
		$res=$e->getResponse();
	}
		echo $res;	
}
     
    }else{
	echo "-1";
	}
    	  
?>