// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
import { KnownJsonWebKeyType as KnownKeyTypes, } from "./generated/models";
export { KnownKeyTypes };
/**
 * The latest supported Key Vault service API version
 */
export const LATEST_API_VERSION = "7.4";
/** Known values of {@link KeyOperation} that the service accepts. */
export var KnownKeyOperations;
(function (KnownKeyOperations) {
    /** Key operation - encrypt */
    KnownKeyOperations["Encrypt"] = "encrypt";
    /** Key operation - decrypt */
    KnownKeyOperations["Decrypt"] = "decrypt";
    /** Key operation - sign */
    KnownKeyOperations["Sign"] = "sign";
    /** Key operation - verify */
    KnownKeyOperations["Verify"] = "verify";
    /** Key operation - wrapKey */
    KnownKeyOperations["WrapKey"] = "wrapKey";
    /** Key operation - unwrapKey */
    KnownKeyOperations["UnwrapKey"] = "unwrapKey";
    /** Key operation - import */
    KnownKeyOperations["Import"] = "import";
})(KnownKeyOperations || (KnownKeyOperations = {}));
/** Known values of {@link KeyExportEncryptionAlgorithm} that the service accepts. */
export var KnownKeyExportEncryptionAlgorithm;
(function (KnownKeyExportEncryptionAlgorithm) {
    /** CKM_RSA_AES_KEY_WRAP Key Export Encryption Algorithm */
    KnownKeyExportEncryptionAlgorithm["CkmRsaAesKeyWrap"] = "CKM_RSA_AES_KEY_WRAP";
    /** RSA_AES_KEY_WRAP_256 Key Export Encryption Algorithm */
    KnownKeyExportEncryptionAlgorithm["RsaAesKeyWrap256"] = "RSA_AES_KEY_WRAP_256";
    /** RSA_AES_KEY_WRAP_384 Key Export Encryption Algorithm */
    KnownKeyExportEncryptionAlgorithm["RsaAesKeyWrap384"] = "RSA_AES_KEY_WRAP_384";
})(KnownKeyExportEncryptionAlgorithm || (KnownKeyExportEncryptionAlgorithm = {}));
//# sourceMappingURL=keysModels.js.map