"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const Image = {
  id: 0x22,
  type: 'IMAGE',
  name: 'Image',
  hasTableName: true,
  declaration: function () {
    return 'image';
  },
  resolveLength: function (parameter) {
    if (parameter.value != null) {
      const value = parameter.value; // TODO: Temporary solution. Replace 'any' more with specific type;

      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(5);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);
    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(parameter.value.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield parameter.value;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!Buffer.isBuffer(value)) {
      throw new TypeError('Invalid buffer.');
    }

    return value;
  }
};
var _default = Image;
exports.default = _default;
module.exports = Image;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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