"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEDAUTHINFOID = {
  STSURL: 0x01,
  SPN: 0x02
};

function fedAuthInfoParser(parser, _options, callback) {
  parser.readUInt32LE(tokenLength => {
    parser.readBuffer(tokenLength, data => {
      let spn, stsurl;
      let offset = 0;
      const countOfInfoIDs = data.readUInt32LE(offset);
      offset += 4;

      for (let i = 0; i < countOfInfoIDs; i++) {
        const fedauthInfoID = data.readUInt8(offset);
        offset += 1;
        const fedAuthInfoDataLen = data.readUInt32LE(offset);
        offset += 4;
        const fedAuthInfoDataOffset = data.readUInt32LE(offset);
        offset += 4;

        switch (fedauthInfoID) {
          case FEDAUTHINFOID.SPN:
            spn = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;

          case FEDAUTHINFOID.STSURL:
            stsurl = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;
          // ignoring unknown fedauthinfo options

          default:
            break;
        }
      }

      callback(new _token.FedAuthInfoToken(spn, stsurl));
    });
  });
}

var _default = fedAuthInfoParser;
exports.default = _default;
module.exports = fedAuthInfoParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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